/* ============ */
/* freqtst.c	*/
/* ============ */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#include <mconf.h>
#include <miscdefs.h>
#include <freqdefs.h>

#define	FULL_SIZE  ((unsigned)RAND_MAX + 1U)
UINT	WorkArea[FULL_SIZE];

#include "execkosm.c"
#include "chisqfrq.c"
#include "ksfreq.c"
#include "exchisq.c"
/* ===================================================================== */
/* freqtst - checks randomness of frequency of numbers produced by rand  */
/* ===================================================================== */
void
main()
{
    CHISQ_STRU	    ChiSqData;
    INIT_DATA_STRU  InitialData;
    KS_DATA_STRU    KSData;

    char    TestType = 0;

    AbortGracefully();			/* Make ^C act reasonably */

    printf("\tF R E Q U E N C Y  T E S T\n\n");
    GetInitialData(&InitialData);
    fflush(NULL); fprintf(stderr, "\n");

    /* -------------------------- */
    /* Print Initial Data Entries */
    /* -------------------------- */
    printf("Starting Seed = %u%s\n", InitialData.UserSeed,
	(InitialData.SeedSrce == (UINT)(-1)) ?
		" (Unsigned Integer Part of Time of Day)" : "");

    printf("Generator     = %s\n", InitialData.GenName);
    fflush(NULL);
    GetChr("\nEnter Type of Test:"
	   "\n\tC = Chi-Square"
	   "\n\tK = Kolmogorov-Smirnov: ", &TestType);
    fflush(NULL); printf("\n");

    TestType = (char)toupper(TestType);

    if (TestType == 'C')
    {
	printf("Test Type     = Chi-Square\n");

	/* -------------------- */
	/* Address of Generator */
	/* -------------------- */
	ChiSqData.RandFun = InitialData.RandFun;

	/* ----------------------- */
	/* Execute Chi-Square Test */
	/* ----------------------- */
	ExecChiSqTest(&ChiSqData);
    }
    else
    {
	printf("Test Type     = Kolmogorov-Smirnov\n");

	/* -------------------- */
	/* Address of Generator */
	/* -------------------- */
	KSData.RandFun = InitialData.RandFun;

	/* ----------------------- */
	/* Execute Chi-Square Test */
	/* ----------------------- */
	ExecKolSmirTest(&KSData);
    }
    printf("End Test of %s Generator\n", InitialData.GenName);
}
